#include <drive/library/cpp/dadata/client.h>
#include <drive/library/cpp/threading/future.h>

#include <rtline/library/json/parse.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/json/json_reader.h>

#include <util/generic/vector.h>
#include <util/string/builder.h>
#include <util/system/env.h>


namespace {
    const TString TestReportData = R"(
        {
            "country": "Россия",
            "region": "Москва",
            "region_with_type": "г Москва",
            "city": null,
            "street": "Академика Королева",
            "house": "3",
            "postal_code": "129515",
            "kladr_id": "7700000000015450062",
            "region_kladr_id": "7700000000000",
            "fias_id": "f64c75cd-a640-41ed-9893-c1aaef58e638",
            "settlement_fias_id": null,
            "street_fias_id": "74779e0c-263e-45a0-b5dc-36ef11f45dba",
            "region_fias_id": "0c5b2444-70a0-4932-980c-b4dc0d3f02b5"
        }
    )";
    const TString TestAddres = "Москва Академика Королева 3";
}

Y_UNIT_TEST_SUITE(DriveDadataSuite) {
    NDrive::TDadataConfig GetConfig() {
        const TString token = GetEnv("DadataApiToken");
        UNIT_ASSERT(token);
        const TString secret = GetEnv("DadataApiSecret");
        UNIT_ASSERT(secret);
        auto config = TStringBuilder()
            << "Token: " << token << Endl
            << "Secret: " << secret << Endl;
        DEBUG_LOG << config << Endl;
        auto result = NDrive::TDadataConfig::ParseFromString(config);
        UNIT_ASSERT(!!result);
        return *result;
    }

    Y_UNIT_TEST(SimpleRequest) {
        if (!GetEnv("DadataApiToken")) {
            return;
        }
        DoInitGlobalLog("console", FromString<ui32>(GetEnv("LogLevel", "6")), false, false);
        auto config = GetConfig();
        const NDrive::TDadataClient client(config);
        auto future = client.CleanAddress({ TestAddres });
        UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
        UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
        UNIT_ASSERT(!future.GetValue().empty());
        NJson::TJsonValue TestReport;
        UNIT_ASSERT(ReadJsonTree(TestReportData, &TestReport));
        UNIT_ASSERT_STRINGS_EQUAL(NJson::ToJson(future.GetValue().front()).GetStringRobust(), TestReport.GetStringRobust());
    }
}
