#pragma once

#include "config.h"

#include <rtline/util/network/neh.h>

#include <library/cpp/tvmauth/client/facade.h>

class TDatasyncClient {
public:
    struct TResponse {
    public:
        TResponse(TStringBuf content, ui16 code);

        explicit operator bool() const {
            return Code == HTTP_OK;
        }
        ui16 GetCode() const {
            return Code;
        }

        const TString& GetError() const;
        const TString& GetDescription() const;
        const TString& GetMessage() const;

        const NJson::TJsonValue& GetValue() const {
            return Value;
        }
        NJson::TJsonValue ExtractValue() {
            return std::move(Value);
        }

    private:
        NJson::TJsonValue Value;
        ui16 Code;
    };

private:
    TDatasyncClientConfig Config;
    TAtomicSharedPtr<NTvmAuth::TTvmClient> Tvm;

    // Requests-related
    TAsyncDelivery::TPtr AsyncDelivery;
    THolder<NNeh::THttpClient> Requester;

private:
    NNeh::THttpRequest ConstructBaseRequest(const TString& collectionName, const TString& documentKey, const ui64 uid) const;
    TInstant ConstructDeadline(TDuration timeout = TDuration::Zero()) const;

public:
    TDatasyncClient(const TDatasyncClientConfig& config, TAtomicSharedPtr<NTvmAuth::TTvmClient> tvm = nullptr);
    ~TDatasyncClient();

    NThreading::TFuture<TResponse> Get(const TString& collection, const TString& key, ui64 uid) const;
    NThreading::TFuture<TResponse> Update(const TString& collection, const TString& key, ui64 uid, const NJson::TJsonValue& payload) const;
    NThreading::TFuture<TResponse> Delete(const TString& collection, const TString& key, ui64 uid) const;

    NNeh::THttpClient::TGuard PerformCollectionRequest(const TString& collectionName, const TString& documentKey, const ui64 uid, THolder<NNeh::THttpAsyncReport::ICallback> && callback) const;
    NUtil::THttpReply PerformSyncCollectionRequest(const TString& collectionName, const TString& documentKey, const ui64 uid) const;

    NNeh::THttpClient::TGuard PerformUpdateRequest(const TString& collectionName, const TString& documentKey, const ui64 uid, const NJson::TJsonValue& payload, THolder<NNeh::THttpAsyncReport::ICallback> && callback) const;
    NUtil::THttpReply PerformSyncUpdateRequest(const TString& collectionName, const TString& documentKey, const ui64 uid, const NJson::TJsonValue& payload) const;
};
