#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/file.h>

void TTVM2AuthConfig::Init(const TYandexConfig::Section* section) {
    Source = section->GetDirectives().Value<ui32>("Source", Source);
    Destination = section->GetDirectives().Value<ui32>("Destination", Destination);
    Token = section->GetDirectives().Value<TString>("Token", Token);
    TokenPath = section->GetDirectives().Value<TString>("TokenPath", TokenPath);
    if (!Token && TokenPath) {
        Token = Strip(TFileInput(TokenPath).ReadAll());
    }
}

void TTVM2AuthConfig::ToString(IOutputStream& os) const {
    os << "Source: " << Source << Endl;
    os << "Destination: " << Destination << Endl;
    os << "TokenPath: " << TokenPath << Endl;
}

void TDatasyncClientConfig::Init(const TYandexConfig::Section* section) {
    const TYandexConfig::TSectionsMap children = section->GetAllChildren();
    const TYandexConfig::Directives& directives = section->GetDirectives();
    {
        auto it = children.find("TVM");
        if (it != children.end()) {
            TvmConfig.Init(it->second);
        }
    }
    {
        auto it = children.find("RequestConfig");
        if (it != children.end()) {
            RequestConfig.InitFromSection(it->second);
        }
    }

    Host = directives.Value("Host", Host);
    Port = directives.Value("Port", Port);
    BaseRoute = directives.Value("BaseRoute", BaseRoute);
    RequestTimeout = directives.Value("RequestTimeout", RequestTimeout);
    SelfClientId = directives.Value("SelfClientId", SelfClientId);
    DestinationClientId = directives.Value("DestinationClientId", DestinationClientId);

    if (TvmConfig.GetSource()) {
        AssertCorrectConfig(TvmConfig.GetDestination() != 0, "proper TVM section should be present in DataSync config");
    } else if (SelfClientId) {
        AssertCorrectConfig(DestinationClientId != 0, "both SelfClientId and DestinationClientId directives should be present in DataSync config");
    }
}

void TDatasyncClientConfig::ToString(IOutputStream& os) const {
    os << "Host: " << Host << Endl;
    os << "Port: " << Port << Endl;
    os << "BaseRoute: " << BaseRoute << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;

    if (SelfClientId && DestinationClientId) {
        os << "SelfClientId: " << SelfClientId << Endl;
        os << "DestinationClientId: " << DestinationClientId << Endl;
    } else {
        os << "<TVM>" << Endl;
        TvmConfig.ToString(os);
        os << "</TVM>" << Endl;
    }

    os << "<RequestConfig>" << Endl;
    RequestConfig.ToString(os);
    os << "</RequestConfig>" << Endl;
}
