#pragma once

#include <rtline/library/metasearch/simple/config.h>

#include <rtline/util/types/accessor.h>

#include <library/cpp/logger/global/global.h>
#include <library/cpp/yconf/conf.h>

class TTVM2AuthConfig {
    R_READONLY(ui32, Source, 0);
    R_READONLY(ui32, Destination, 0);
    R_READONLY(TString, TokenPath);
    R_READONLY(TString, Token);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};

class TDatasyncClientConfig {
    R_READONLY(TString, Host);
    R_READONLY(ui32, Port, 0);
    R_READONLY(TString, BaseRoute);
    R_READONLY(TDuration, RequestTimeout, TDuration::Zero());

    R_READONLY(TTVM2AuthConfig, TvmConfig);
    R_READONLY(NSimpleMeta::TConfig, RequestConfig);
    R_READONLY(ui32, SelfClientId, 0);
    R_READONLY(ui32, DestinationClientId, 0);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
};
