#pragma once

#include <drive/backend/database/entity/manager.h>

struct TDatasyncQueueError : public virtual yexception {
};

class TDatasyncQueueEntry {
private:
    R_FIELD(TString, AssignmentId);
    R_FIELD(TInstant, CreatedAt);
    R_FIELD(TInstant, ProcessAt);
    R_FIELD(ui64, Attempt, 1);

    R_OPTIONAL(TString, ReturnReason);
    R_OPTIONAL(TString, UserId);

public:
    TString GetMainId() const {
        return GetAssignmentId();
    }

    class TDatasyncEntryDecoder: public TBaseDecoder {
        R_FIELD(i32, AssignmentId, -1);
        R_FIELD(i32, CreatedAt, -1);
        R_FIELD(i32, ProcessAt, -1);
        R_FIELD(i32, Attempt, -1);

    public:
        TDatasyncEntryDecoder() = default;
        TDatasyncEntryDecoder(const TMap<TString, ui32>& decoderBase) {
            AssignmentId = GetFieldDecodeIndex("assignment_id", decoderBase);
            CreatedAt = GetFieldDecodeIndex("created_at", decoderBase);
            ProcessAt = GetFieldDecodeIndex("process_at", decoderBase);
            Attempt = GetFieldDecodeIndex("attempt", decoderBase);
        }
    };
    using TDecoder = TDatasyncEntryDecoder;

    bool DeserializeWithDecoder(const TDatasyncEntryDecoder& decoder, const TConstArrayRef<TStringBuf> & values, const IHistoryContext*);

    bool Parse(const NStorage::TTableRecord& row);
    NStorage::TTableRecord SerializeToTableRecord() const;
};

class TDatasyncQueueClient: public TDBEntities<TDatasyncQueueEntry> {
private:
    using TBase = TDBEntities<TDatasyncQueueEntry>;

public:
    using TBase::TBase;

    TDatasyncQueueClient(const NStorage::IDatabase::TPtr database)
    : TBase(database) {
    }

    virtual TString GetTableName() const override {
        return "datasync_queue";
    }

    virtual TString GetColumnName() const override {
        return "assignment_id";
    }

    virtual TString GetMainId(const TDatasyncQueueEntry& entry) const final {
        return entry.GetMainId();
    }

    NDrive::TEntitySession BuildSession(bool readonly = false) const;

    TMap<TString, TDatasyncQueueEntry> Get(ui64 amount, NDrive::TEntitySession& session) const;
    bool Delete(const TString& assignmentId, NDrive::TEntitySession& session) const;
    bool Push(const TString& assignmentId, NDrive::TEntitySession& session) const;
    bool Return(TDatasyncQueueEntry assignment, NDrive::TEntitySession& session) const;
    ui64 Size(NDrive::TEntitySession& session) const;
};
