#include "signature.h"

#include <drive/library/cpp/openssl/oio.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

#include <util/folder/path.h>

Y_UNIT_TEST_SUITE(DeeplinkSuite) {
    Y_UNIT_TEST(Signature) {
        auto privateKeyPath = TFsPath(ArcadiaSourceRoot()) / "drive/library/cpp/deeplink/ut/private.pem";
        auto privateKey = NOpenssl::GetPrivateKeyFromFile(privateKeyPath);
        TString deeplink = "fake";
        TString signature = NDrive::GetDeeplinkSignature(deeplink, privateKey);
        Cout << signature << Endl;
        UNIT_ASSERT_VALUES_EQUAL(signature, "fsgwpG7kyWSpoYDycaCdrdSqMHBcrJiYihr3Agr4Z/EW0Lnhsb6qjD1msVUc+/fMOy0TAJjLfhItEccGmaUigVYe0stpjZoYBEGTv5OVHQNrZ4VdQ7q0hxODCKbtEK4XzE8/TyGzlXlP3gRIT04VL1nElhqgnAUVATl2lXHs1FtyMQC7t3dHXMVEPD4049iW3dGnW0L+0qFn5/9+LomOgYeK8qd9jUOYp22sdyywQUfadtbLKwZAwxwYSzWrA8wyT32fmNfSzgUCDFRhdue+wwW9JvGb8O3UUH0NiQqxxNcAjnjJuSEZYizmHIMeizwhS6LEZDktjX+GnpJgcm9rJw==");
    }
}
