#pragma once

#include <util/generic/ptr.h>
#include <library/cpp/json/writer/json_value.h>
#include <rtline/util/types/messages_collector.h>

class IDocumentStorage {
public:
    class IDocumentStorageFile {
    public:
        class ICallback {
        public:
            using TPtr = TAtomicSharedPtr<ICallback>;
            virtual ~ICallback() = default;
            virtual void ProcessSuccess(const TString& data) = 0;
            virtual void ProcessError(const TString& error) = 0;
        };

    public:
        using TPtr = TAtomicSharedPtr<IDocumentStorageFile>;

        virtual ~IDocumentStorageFile() = default;
        virtual bool GetData(TString& data, TMessagesCollector& errors) const = 0;
        virtual void GetDataAsync(IDocumentStorageFile::ICallback::TPtr callback) const = 0;
        virtual const TString& GetName() const = 0;
    };

    virtual ~IDocumentStorage() = default;
    virtual bool GetFiles(const TString& path, TVector<IDocumentStorageFile::TPtr>& fileList, TMessagesCollector& errors) const = 0;
};
