#include "config.h"

#include <util/stream/file.h>

void TYandexDiskClientConfig::Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy) {
    Token = section->GetDirectives().Value("Token", Token);
    TokenPath = section->GetDirectives().Value("TokenPath", TokenPath);
    if (!Token && TokenPath) {
        Token = Strip(TFileInput(TokenPath).ReadAll());
    }
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);

    FileFields = section->GetDirectives().Value("FileFields", FileFields);

    auto subSections = section->GetAllChildren();

    auto commonSection = subSections.find("ClientConfig");
    AssertCorrectConfig(commonSection != subSections.end(), "ClientConfig section absent");
    ClientConfig.Init(commonSection->second, requestPolicy);

    auto downloadSection = subSections.find("DownloadClientConfig");
    AssertCorrectConfig(downloadSection != subSections.end(), "DownloadClientConfig section absent");
    DownloadClientConfig.Init(downloadSection->second, requestPolicy);
}

void TYandexDiskClientConfig::ToString(IOutputStream& os) const {
    os << "TokenPath: " << TokenPath << Endl;
    os << "RequestTimeout: " << RequestTimeout << Endl;

    os << "FileFields: " << FileFields << Endl;

    os << "<ClientConfig>" << Endl;
    ClientConfig.ToString(os);
    os << "</ClientConfig>" << Endl;

    os << "<DownloadClientConfig>" << Endl;
    DownloadClientConfig.ToString(os);
    os << "</DownloadClientConfig>" << Endl;
}
