#pragma once
#include <rtline/library/deprecated/async_impl/config.h>

class TYandexDiskClientConfig {
    R_READONLY(TString, Token);
    R_READONLY(TString, TokenPath);

    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));

    R_READONLY(TString, FileFields);
    R_READONLY(TAsyncApiImpl::TConfig, ClientConfig);
    R_READONLY(TAsyncApiImpl::TConfig, DownloadClientConfig);

public:
    void Init(const TYandexConfig::Section* section, const TMap<TString, NSimpleMeta::TConfig>* requestPolicy);
    void ToString(IOutputStream& os) const;

    static TYandexDiskClientConfig ParseFromString(const TString& configStr) {
        TYandexDiskClientConfig result;
        TAnyYandexConfig config;
        CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
        result.Init(config.GetRootSection(), nullptr);
        return result;
    }
};
