#pragma once

#include <rtline/library/deprecated/async_impl/logger.h>

enum EYandexDiskOperationType {
    GetDownloadPath /* "get_download_path" */,
    GetFiles /* "get_files" */,
};

class TYandexDiskLogger : public TRequestLogger<EYandexDiskOperationType> {
    using TBase = TRequestLogger<EYandexDiskOperationType>;

public:
    TYandexDiskLogger(const TString& source)
        : TBase(source, "yandex-disk-api")
        , SourceCount(1)
    {
    }

    void RegisterSource() const {
        ++SourceCount;
        TUnistatSignalsCache::SignalMaxX("yandex-disk", "source-count", SourceCount.load(std::memory_order_relaxed));
    }

private:
    mutable std::atomic<ui64> SourceCount;
};
