#pragma once

#include "config.h"
#include "entities.h"


namespace NDrive {

    class TElementFinesClient {
    public:
        struct TFinesRequestParams {
            ui64 Limit = 0;
            ui64 Offset = 0;
            TInstant Since = TInstant::Zero();
            TInstant LastUpdate = TInstant::Zero();
        };

    public:
        TElementFinesClient(const TFinesApiConfig& config);
        const TFinesApiConfig& GetConfig() const;
        NThreading::TFuture<TVector<TElementFine>> GetFines(const TFinesRequestParams& context) const;
        NThreading::TFuture<TVector<TElementFineAttachment>> GetViolationPhotos(const TString& rulingNumber) const;
        NThreading::TFuture<TVector<TElementCarData>> GetCarsData() const;
        NThreading::TFuture<TVector<TElementCarData>> AddCars(const TVector<TElementCarData>& cars) const;
        NThreading::TFuture<TVector<TElementCarData>> ChangeCarsActivity(const TVector<TElementCarData>& cars) const;

    private:
        TFinesApiConfig Config;
        THolder<NNeh::THttpClient> Client;
    };

}
