#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/folder/path.h>
#include <util/stream/file.h>

namespace NDrive {

    void TFinesApiConfig::Init(const TYandexConfig::Section* section) {
        Uri = section->GetDirectives().Value("Uri", Uri);
        FinesUriPath = section->GetDirectives().Value("FinesUriPath", FinesUriPath);
        PhotosUriPath = section->GetDirectives().Value("PhotosUriPath", PhotosUriPath);
        CarUriPath = section->GetDirectives().Value("CarUriPath", CarUriPath);
        Token = section->GetDirectives().Value("Token", Token);
        TokenPath = section->GetDirectives().Value("TokenPath", TokenPath);
        AssertCorrectConfig(Token || TokenPath, "neither token nor token path are defined");
        if (!Token) {
            AssertCorrectConfig(TFsPath(TokenPath).Exists(), "Incorrect path for tanker's apikey in 'TokenPath'");
            TFileInput fi(TokenPath);
            Token = fi.ReadAll();
        }
        {
            const TYandexConfig::TSectionsMap children = section->GetAllChildren();
            auto it = children.find("RequestConfig");
            if (it != children.end()) {
                RequestConfig.InitFromSection(it->second);
            }
        }
        RequestTimeout  = section->GetDirectives().Value("RequestTimeout", RequestTimeout);
    }

    void TFinesApiConfig::ToString(IOutputStream& os) const {
        os << "Uri: " << Uri << Endl;
        os << "FinesUriPath: " << FinesUriPath << Endl;
        os << "PhotosUriPath: " << PhotosUriPath << Endl;
        os << "CarUriPath: " << CarUriPath << Endl;
        if (TokenPath) {
            os << "TokenPath: " << TokenPath << Endl;
        } else {
            os << "Token: " << Token << Endl;
        }
        os << "<RequestConfig>" << Endl;
        RequestConfig.ToString(os);
        os << "</RequestConfig>" << Endl;
        os << "RequestTimeout : " << RequestTimeout << Endl;
    }

    void TFinesApiConfig::Authorize(NNeh::THttpRequest& request) const {
        TString reqData = Base64Encode(GetToken());
        request.AddHeader("Authorization", "Basic " + reqData);
    }

    TFinesApiConfig TFinesApiConfig::ParseFromString(const TString& configStr) {
        TFinesApiConfig result;
        TAnyYandexConfig config;
        AssertCorrectConfig(config.ParseMemory(configStr.data()), "Fail to parse config:" + configStr);
        result.Init(config.GetRootSection());
        return result;
    }

}
