#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive {
    class TFinesApiConfig {
    public:
        void Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        void Authorize(NNeh::THttpRequest& request) const;
        static TFinesApiConfig ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri, "https://taksi.0nalog.com:1703/");
        R_READONLY(TString, FinesUriPath, "yandrive/hs/Fines/v1/Load");
        R_READONLY(TString, PhotosUriPath, "yandrive/hs/Fines/v1/LoadByFineNumber");
        R_READONLY(TString, CarUriPath, "yandrive/hs/Car/v1");
        R_READONLY(TString, Token);
        R_READONLY(TString, TokenPath);
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    };
}
