#pragma once

#include <rtline/util/types/accessor.h>

#include <library/cpp/json/json_value.h>

#include <util/memory/blob.h>

namespace NDrive {

    class TElementFineAttachment {
        R_FIELD(TString, Data);
    };

    class TElementFine {
    public:
        enum EPamentFields {
            INN = 0,
            KBK = 1,
        };

    private:
        R_FIELD(TString, ProtocolNumber);
        R_FIELD(TInstant, ProtocolDate, TInstant::Zero());
        R_FIELD(TInstant, ViolationTimestamp, TInstant::Zero());
        R_FIELD(double, Sum, 0);
        R_FIELD(double, PartPayment, 0);
        R_FIELD(bool, Paid, false);
        R_FIELD(bool, PaidByCompany, false);
        R_FIELD(TString, Article);
        R_FIELD(TString, ArticleCode);
        R_FIELD(bool, PossibleDiscount, false);
        R_FIELD(TString, ViolationPlace);
        R_FIELD(TString, Department);
        R_FIELD(TString, CarNumber);
        R_FIELD(TString, CarSTS);
        R_FIELD(bool, PhotoFixation, false);
        R_FIELD(TString, Status);
        R_FIELD(TInstant, DiscountDate, TInstant::Zero());
        R_FIELD(NJson::TJsonValue, PaymentData);
    };

    enum EDepartment {
        Unknown = 0         /* "unknown" */,
        NeedPay = 1         /* "Нужно оплатить" */,
        NoNeedPay = 2       /* "Не требует оплаты" */,
    };

    class TElementCarData {
        R_FIELD(TString, Number);
        R_FIELD(TString, StsSeries);
        R_FIELD(TString, StsNumber);
        R_FIELD(TString, Vin);
        R_FIELD(TString, Model);
        R_FIELD(EDepartment, Department, EDepartment::Unknown);
        R_OPTIONAL(bool, Activity);
    };

}
