#include <drive/library/cpp/element/client.h>
#include <drive/library/cpp/element/entities.h>
#include <drive/library/cpp/threading/future.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/json/json_reader.h>

#include <util/generic/vector.h>
#include <util/string/builder.h>
#include <util/system/env.h>


Y_UNIT_TEST_SUITE(DriveElementFineSuite) {
    NDrive::TFinesApiConfig GetFinesConfig() {
        TStringBuilder config;
        if (auto uri = GetEnv("ElementApiUri")) {
            config << "Uri: " << uri << Endl;
        }
        if (auto token = GetEnv("ElementApiToken")) {
            config << "Token: " << token << Endl;
        }
        DEBUG_LOG << config << Endl;
        return NDrive::TFinesApiConfig::ParseFromString(config);
    }

    Y_UNIT_TEST(SimpleRequest) {
        DoInitGlobalLog("console", FromString<ui32>(GetEnv("LogLevel", "6")), false, false);
        auto config = GetFinesConfig();
        const NDrive::TElementFinesClient client(config);
        NDrive::TElementFinesClient::TFinesRequestParams params;
        params.Limit = 1;
        auto future = client.GetFines(params);
        UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
        UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
        auto& fines = future.GetValue();
        UNIT_ASSERT_VALUES_EQUAL(fines.size(), 1);
        auto& fine = fines.front();
        UNIT_ASSERT(fine.IsPaid());
        UNIT_ASSERT_VALUES_EQUAL(fine.GetViolationTimestamp().FormatLocalTime("%Y-%m-%d %H:%M:%S"), "2021-04-03 14:12:00");
        UNIT_ASSERT_VALUES_EQUAL(fine.GetProtocolDate().FormatLocalTime("%Y-%m-%d %H:%M:%S"), "2021-04-06 00:00:00");
        UNIT_ASSERT_VALUES_EQUAL(fine.GetDepartment(), "Московская административная дорожная инспекция");
        auto photoFuture = client.GetViolationPhotos(fine.GetProtocolNumber());
        UNIT_ASSERT(photoFuture.Wait(config.GetRequestTimeout()));
        UNIT_ASSERT_C(photoFuture.HasValue(), NThreading::GetExceptionMessage(photoFuture));
        auto& photos = photoFuture.GetValue();
        UNIT_ASSERT_VALUES_EQUAL(photos.size(), 2);
    }
}
