#pragma once
#include <rtline/util/types/expected.h>
#include <rtline/util/types/accessor.h>

class TExpressionCalculator {
private:
    enum class EOperation {
        Undefined,
        Add,
        Sub,
        Mul,
        Div,
    };

    class IElement {
    public:
        virtual ~IElement() = default;
        virtual bool Calc(double& result) const = 0;
        static THolder<IElement> Construct(TStringBuf original);
    };

    class TOperation : public IElement {
        R_READONLY(EOperation, Operation, EOperation::Undefined);
        R_READONLY(THolder<IElement>, Left, nullptr);
        R_READONLY(THolder<IElement>, Right, nullptr);
    public:
        TOperation(const EOperation operation, THolder<IElement> left, THolder<IElement> right)
            : Operation(operation)
            , Left(left.Release())
            , Right(right.Release())
        {}
        virtual bool Calc(double& result) const override;
    };

    class TConst : public IElement {
        R_READONLY(double, Value, 0);
    public:
        TConst(const double value)
            : Value(value)
        {}
        virtual bool Calc(double& result) const override {
            result = Value;
            return true;
        }
    };

private:
    R_READONLY(TString, RawExpression);

public:
    TExpressionCalculator(const TString& exp)
        : RawExpression(exp)
    {}

    TExpected<double, TString> Calc(const TVector<double>& values) const;
    TExpected<double, TString> Calc(const TMap<TString, double>& values) const;

private:
    TExpected<double, TString> Calc(const TString& exp) const;
};
