#pragma once

#include "device.h"

#include <rtline/api/search_client/neh_client.h>

namespace NDrive {
    class TExternalDeviceClient {
    public:
        TExternalDeviceClient(const NRTLine::TNehSearchClient& client)
            : Client(client)
        {
        }

        NThreading::TFuture<TExternalDeviceSnapshots> GetOperator(const TString& name) const;
        NThreading::TFuture<TExternalDeviceSnapshots> GetRegion(const TString& name) const;

    private:
        NThreading::TFuture<TExternalDeviceSnapshots> GetSnapshots(const TString& key, const TString& value) const;

    private:
        const NRTLine::TNehSearchClient& Client;
    };
}
