#include "client.h"
#include "map.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ExternalDeviceClient) {
    Y_UNIT_TEST(Simple) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TExternalDeviceClient client(searchClient);
        auto msk = client.GetRegion("msk");
        UNIT_ASSERT(msk.Initialized());
        UNIT_ASSERT(msk.Wait(TDuration::Seconds(10)));
        UNIT_ASSERT(msk.HasValue());
        auto snapshots = msk.ExtractValue();
        UNIT_ASSERT(!snapshots.empty());
        const auto& snapshot = snapshots[0];
        const auto& devices = snapshot.Devices;
        UNIT_ASSERT(!devices.empty());
        const auto& device = devices[0];
        UNIT_ASSERT(device.Id);
        UNIT_ASSERT(device.Coordinate.X > 0);
        UNIT_ASSERT(device.Coordinate.Y > 0);

        auto deviceMap = NDrive::TExternalDeviceMap(snapshots[0]);
        UNIT_ASSERT_VALUES_EQUAL(deviceMap.GetTimestamp(), snapshot.Timestamp);
        UNIT_ASSERT_VALUES_EQUAL(deviceMap.GetRegion(), snapshot.Region);
        UNIT_ASSERT_VALUES_EQUAL(deviceMap.GetOperator(), snapshot.Operator);
        auto devicesFromMap = deviceMap.GetDevices(TGeoRect(37.360205, 55.633762, 37.838111, 55.841406));
        UNIT_ASSERT(devicesFromMap.size() > 100);
    }
}
