#include "device.h"

#include <drive/library/cpp/external/proto/device.pb.h>

void NDrive::TExternalDevice::Serialize(NDrive::NProto::TExternalDevice& proto) const {
    proto.SetId(Id);
    proto.SetLatitude(Coordinate.Y);
    proto.SetLongitude(Coordinate.X);
    if (Number) {
        proto.SetNumber(Number);
    }
    if (Model) {
        proto.SetModel(Model);
    }
    if (FuelLevel) {
        proto.SetFuelLevel(*FuelLevel);
    }
    if (FuelDistance) {
        proto.SetFuelDistance(*FuelDistance);
    }
    if (ParkingPrice) {
        proto.SetParkingPrice(*ParkingPrice);
    }
    if (ReservationPrice) {
        proto.SetReservationPrice(*ReservationPrice);
    }
    if (RidingPrice) {
        proto.SetRidingPrice(*RidingPrice);
    }
}

bool NDrive::TExternalDevice::Deserialize(const NDrive::NProto::TExternalDevice& proto) {
    if (proto.HasId()) {
        Id = proto.GetId();
    } else {
        return false;
    }
    Coordinate = {
        proto.GetLongitude(),
        proto.GetLatitude()
    };
    if (proto.HasNumber()) {
        Number = proto.GetNumber();
    }
    if (proto.HasModel()) {
        Model = proto.GetModel();
    }
    if (proto.HasFuelLevel()) {
        FuelLevel = proto.GetFuelLevel();
    }
    if (proto.HasFuelDistance()) {
        FuelDistance = proto.GetFuelDistance();
    }
    if (proto.HasParkingPrice()) {
        ParkingPrice = proto.GetParkingPrice();
    }
    if (proto.HasReservationPrice()) {
        ReservationPrice = proto.GetReservationPrice();
    }
    if (proto.HasRidingPrice()) {
        RidingPrice = proto.GetRidingPrice();
    }
    return true;
}

void NDrive::TExternalDeviceSnapshot::Serialize(NDrive::NProto::TExternalDeviceSnapshot& proto) const {
    if (Operator) {
        proto.SetOperator(Operator);
    }
    if (Region) {
        proto.SetRegion(Region);
    }
    if (Timestamp) {
        proto.SetTimestamp(Timestamp.Seconds());
    }
    for (auto&& device : Devices) {
        device.Serialize(*proto.AddDevice());
    }
}

bool NDrive::TExternalDeviceSnapshot::Deserialize(const NDrive::NProto::TExternalDeviceSnapshot& proto) {
    if (proto.HasOperator()) {
        Operator = proto.GetOperator();
    } else {
        return false;
    }
    if (proto.HasRegion()) {
        Region = proto.GetRegion();
    }
    if (proto.HasTimestamp()) {
        Timestamp = TInstant::Seconds(proto.GetTimestamp());
    } else {
        return false;
    }
    for (auto&& device : proto.GetDevice()) {
        TExternalDevice d;
        if (d.Deserialize(device)) {
            Devices.push_back(std::move(d));
        } else {
            return false;
        }
    }
    return true;
}
