#pragma once

#include <rtline/library/geometry/rect.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDrive::NProto {
    class TExternalDevice;
    class TExternalDeviceSnapshot;
}

namespace NDrive {
    class TExternalDevice {
    public:
        TString Id;
        TString Number;
        TString Model;

        TGeoCoord Coordinate;
        TMaybe<float> FuelLevel;
        TMaybe<float> FuelDistance;
        TMaybe<ui32> ParkingPrice;
        TMaybe<ui32> ReservationPrice;
        TMaybe<ui32> RidingPrice;

    public:
        bool operator<(const TExternalDevice& other) const {
            return Id < other.Id;
        }
        bool operator==(const TExternalDevice& other) const {
            return Id == other.Id;
        }

        TGeoRect GetRect() const {
            return { Coordinate };
        }

        void Serialize(NDrive::NProto::TExternalDevice& proto) const;
        bool Deserialize(const NDrive::NProto::TExternalDevice& proto);
    };
    using TExternalDevices = TVector<TExternalDevice>;

    struct TExternalDeviceSnapshotId {
        TString Operator;
        TString Region;

        bool operator<(const TExternalDeviceSnapshotId& other) const {
            return std::tie(Operator, Region) < std::tie(other.Operator, other.Region);
        }
        bool operator==(const TExternalDeviceSnapshotId& other) const {
            return std::tie(Operator, Region) == std::tie(other.Operator, other.Region);
        }
    };

    class TExternalDeviceSnapshot: public TExternalDeviceSnapshotId {
    public:
        TInstant Timestamp;
        TExternalDevices Devices;

    public:
        void Serialize(NDrive::NProto::TExternalDeviceSnapshot& proto) const;
        bool Deserialize(const NDrive::NProto::TExternalDeviceSnapshot& proto);
    };
    using TExternalDeviceSnapshots = TVector<TExternalDeviceSnapshot>;
}
