#pragma once

#include "client.h"
#include "map.h"

#include <rtline/util/auto_actualization.h>

namespace NDrive {
    namespace NExternalDeviceManager {
        class TDevice : protected TExternalDevice {
        public:
            using TBase = TExternalDevice;

        public:
            using TBase::Id;
            using TBase::Model;
            using TBase::Number;
            using TBase::Coordinate;
            using TBase::FuelDistance;
            using TBase::FuelLevel;
            using TBase::ParkingPrice;
            using TBase::ReservationPrice;
            using TBase::RidingPrice;
            TString Operator;
            TInstant Timestamp;

        public:
            TDevice(const TBase& base, const TString& op, TInstant timestamp)
                : TBase(base)
                , Operator(op)
                , Timestamp(timestamp)
            {
            }
        };
        using TDevices = TVector<TDevice>;
    }

    class TExternalDeviceManager: public IAutoActualization {
    public:
        using TDevice = NExternalDeviceManager::TDevice;
        using TDevices = TVector<TDevice>;
        using TSnapshots = TVector<TExternalDeviceMapPtr>;

        struct TOptions {
            TMap<TString, TSet<TString>> OperatorGroups;
            TVector<TString> Regions = {
                "msk",
                "spb"
            };
        };

    public:
        TExternalDeviceManager(const NRTLine::TNehSearchClient& client, const TOptions& options);
        ~TExternalDeviceManager();

        TDevices GetDevices(const TGeoRect& rectangle, TStringBuf group, TDuration freshness) const;
        TDevices GetDevices(const TGeoRect& rectangle, TStringBuf group = {}, TInstant actuality = TInstant::Zero()) const;
        TSnapshots GetSnapshots() const;

        virtual bool GetStartFailIsProblem() const override;
        virtual bool Refresh() override;

    private:
        const TExternalDeviceClient Client;
        const TOptions Options;

        TMap<TExternalDeviceSnapshotId, TExternalDeviceMapPtr> Snapshots;
        TRWMutex Lock;
    };
}
