#include "manager.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(ExternalDeviceManagerSuite) {
    Y_UNIT_TEST(Simple) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TExternalDeviceManager::TOptions options;
        NDrive::TExternalDeviceManager manager(searchClient, options);
        UNIT_ASSERT(manager.Refresh());

        auto snapshots = manager.GetSnapshots();
        UNIT_ASSERT(snapshots.size() > 0);

        auto devices = manager.GetDevices(TGeoRect(37.360205, 55.633762, 37.838111, 55.841406));
        UNIT_ASSERT(devices.size() > 100);
    }

    Y_UNIT_TEST(Groups) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TExternalDeviceManager::TOptions options;
        TString group = "CarpTier";
        TString op = GetEnv("CARP_TIER");
        UNIT_ASSERT(op);
        options.OperatorGroups[group].insert(op);
        NDrive::TExternalDeviceManager manager(searchClient, options);
        UNIT_ASSERT(manager.Refresh());

        auto devices = manager.GetDevices(TGeoRect(37.360205, 55.633762, 37.838111, 55.841406), group);
        UNIT_ASSERT(devices.size() > 10);
        for (auto&& device : devices) {
            UNIT_ASSERT_VALUES_EQUAL(device.Operator, op);
        }
    }
}
