#include "map.h"

NDrive::TExternalDeviceMap::TExternalDeviceMap(const TExternalDeviceSnapshot& snapshot)
    : Operator(snapshot.Operator)
    , Region(snapshot.Region)
    , Timestamp(snapshot.Timestamp)
    , DevicesHash(TGeoRect(-180, -90, 180, 90))
{
    for (auto&& device : snapshot.Devices) {
        DevicesHash.AddObject(device);
    }
}

NDrive::TExternalDeviceMap::TDevices NDrive::TExternalDeviceMap::GetDevices(const TGeoRect& rectangle) const {
    TDevices result;
    auto actor = [&result](const TExternalDevice& device) {
        result.push_back(&device);
        return true;
    };
    DevicesHash.FindObjects(rectangle, actor);
    std::sort(result.begin(), result.end(), [](const TExternalDevice* left, const TExternalDevice* right) {
        return left && right && left->Id < right->Id;
    });
    auto u = std::unique(result.begin(), result.end(), [](const TExternalDevice* left, const TExternalDevice* right) {
        return left && right && left->Id == right->Id;
    });
    result.erase(u, result.end());
    return result;
}
