#pragma once

#include "device.h"

#include <rtline/library/rect_hash/rect_hash.h>

namespace NDrive {
    class TExternalDeviceMap {
    public:
        using TDevices = TVector<const TExternalDevice*>;

    public:
        TExternalDeviceMap(const TExternalDeviceSnapshot& snapshot);

        const TString& GetOperator() const {
            return Operator;
        }
        const TString& GetRegion() const {
            return Region;
        }
        TInstant GetTimestamp() const {
            return Timestamp;
        }

        TDevices GetDevices(const TGeoRect& rectangle) const;

    private:
        const TString Operator;
        const TString Region;
        const TInstant Timestamp;

        TRectHash<TGeoCoord, TExternalDevice> DevicesHash;
    };
    using TExternalDeviceMapPtr = TAtomicSharedPtr<TExternalDeviceMap>;
}
