#pragma once

#include <rtline/api/search_client/neh_client.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/library/json/field.h>

#include <library/cpp/langs/langs.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace NDrive {
    class TGeocoder {
    public:
        struct TResponse {
            TString Description;
            TString Title;
            TString Kind;
            ui64 GeoId = 0;

            DECLARE_FIELDS(
                Field(Description, "description"),
                Field(Title, "title"),
                Field(Kind, "kind"),
                Field(GeoId, "geoid")
            );
        };

        struct TOptions {
            TString Host = "addrs-testing.search.yandex.net";
            ui16 Port = 80;
            TString Path = "search/stable/yandsearch";
            TString Origin = "yandex.drive";
            TString RevMode = "taxi2";
            TDuration Timeout = TDuration::MilliSeconds(250);

            TString TvmToken;
            ui32 TvmDestination = 0;
            ui32 TvmSource = 0;

            void ToString(IOutputStream& os) const;
            void Init(const TYandexConfig::Section* section);
        };

    public:
        TGeocoder(const TOptions& options, TMaybe<NDrive::TTvmAuth> tvmAuth = Nothing(), TAtomicSharedPtr<TAsyncDelivery> ad = nullptr);
        ~TGeocoder();

        NThreading::TFuture<TResponse> Decode(const TGeoCoord& coordinate, ELanguage language = LANG_RUS) const;

    private:
        const TOptions Options;
        const NRTLine::TNehSearchClient Client;
    };
}
