#include "client.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(GeocoderClientSuite) {
    Y_UNIT_TEST(Simple) {
        NDrive::TGeocoder::TOptions options;
        NDrive::TGeocoder client(options);

        TGeoCoord coordinate = { 37.589961, 55.733858 };
        auto decodedF = client.Decode(coordinate);
        UNIT_ASSERT(decodedF.Initialized());
        NDrive::TGeocoder::TResponse decoded = decodedF.GetValueSync();
        UNIT_ASSERT_VALUES_EQUAL(decoded.GeoId, 213);
        UNIT_ASSERT(decoded.Title);
        UNIT_ASSERT_VALUES_EQUAL(decoded.Kind, "house");
    }

    Y_UNIT_TEST(WithTvm) {
        ui32 source = FromStringWithDefault(GetEnv("TVM_SOURCE"), 2000184);
        TString token = GetEnv("TVM_TOKEN", "2MOzJtXfbLvZ3ySzj3zmRw");
        UNIT_ASSERT(token);

        NDrive::TGeocoder::TOptions options;
        options.Host = "addrs.yandex.ru";
        options.Port = 17140;
        options.Path = "yandsearch";
        options.TvmDestination = 2001886;
        options.TvmSource = source;

        NTvmAuth::NTvmApi::TClientSettings::TDstVector destinations;
        destinations.emplace_back(options.TvmDestination);
        NTvmAuth::NTvmApi::TClientSettings settings;
        settings.SetSelfTvmId(options.TvmSource);
        settings.EnableServiceTicketsFetchOptions(token, std::move(destinations));
        auto tvmClient = MakeHolder<NTvmAuth::TTvmClient>(settings, MakeIntrusive<NTvmAuth::TDevNullLogger>());
        auto tvmAuth = NDrive::TTvmAuth(std::move(tvmClient), options.TvmDestination);
        NDrive::TGeocoder client(options, std::move(tvmAuth));

        TGeoCoord coordinate = { 37.589961, 55.733858 };
        auto decodedF = client.Decode(coordinate);
        UNIT_ASSERT(decodedF.Initialized());
        NDrive::TGeocoder::TResponse decoded = decodedF.GetValueSync();
        UNIT_ASSERT_VALUES_EQUAL(decoded.GeoId, 213);
        UNIT_ASSERT(decoded.Title);
        UNIT_ASSERT_VALUES_EQUAL(decoded.Kind, "house");
    }
}
