#include "formatter.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(GeocoderFormatterSuite) {
    Y_UNIT_TEST(ShortenAddress) {
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Ленинский проспект 40"), "Ленинский проспект 40");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Ленинский проспект 40", 18), "Ленинский пр-т 40");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("проспект Мира, 98Ас8", 18), "пр-т Мира, 98Ас8");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("проспект Мира, 79/9Ас12", 18), "пр-т Мира, 79/9Ас12");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Союзный проспект, 22", 18), "Союзный пр-т, 22");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Сапёрный проезд, 6к2", 18), "Сапёрный пр-д, 6к2");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("улица 10-летия Октября, вл10", 18), "ул. 10-л. Октября, вл10");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Усачёва улица, 29к7", 18), "Усачёва ул., 29к7");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Ленинский проспект 40", 0), "Ленинск. пр-т 40");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("проспект Мира, 98Ас8", 0), "пр-т Мира, 98Ас8");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("проспект Мира, 79/9Ас12", 0), "пр-т Мира, 79/9Ас12");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Союзный проспект, 22", 0), "Союзн. пр-т, 22");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Сапёрный проезд, 6к2", 0), "Сапёрн. пр-д, 6к2");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("улица 10-летия Октября, вл10", 0), "ул. 10-л. Октября, вл10");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("Усачёва улица, 29к7", 0), "Усач. ул., 29к7");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("проспект 60-летия Октября", 0), "пр-т 60-л. Октября");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::SmartShortenAddress("улица Фотиевой, 5с2", 0), "ул. Фотиев., 5с2");

        UNIT_ASSERT_VALUES_EQUAL(NDrive::ShortenAddress("Ленинский проспект 40", 10), "Ленинск...");
        UNIT_ASSERT_VALUES_EQUAL(NDrive::ShortenAddress("проспект Мира, 98Ас8", 10), "пр-т Ми...");
    }
}
