#pragma once

#include "features.h"

#include <drive/library/cpp/taxi/scooters_surge/client.h>
#include <drive/library/cpp/rtmr/client.h>

#include <library/cpp/threading/future/future.h>

class TGeoCoord;

namespace NNeh {
    class THttpClient;
}

namespace NRTLine {
    class TNehSearchClient;
}

namespace NDrive {
    class TGeoFeaturesClient {
    public:
        struct TOptions {
            TString ReqIdClass = "GEOFEATURES";
            TDuration Timeout = TDuration::MilliSeconds(300);
        };

    public:
        static TString GetUrl(double latitude, double longitude);
        static TString GetUrl(ui64 geobaseId);
        static TString GetGeoId(double latitude, double longitude);
        static TString GetGeoId(ui64 geobaseId);

    public:
        TGeoFeaturesClient(
            const NRTLine::TNehSearchClient& client,
            const NDrive::TRtmrSurgeClient& rtmrClient,
            TAtomicSharedPtr<TScootersSurge> scootersSurge = nullptr,
            TOptions options = Default<TOptions>()
        );
        ~TGeoFeaturesClient();

        NThreading::TFuture<TOptionalGeoFeatures> Get(const TGeoCoord& coordinate) const;
        NThreading::TFuture<TOptionalGeoFeatures> Get(double latitude, double longitude) const;
        NThreading::TFuture<TOptionalGeoFeatures> Get(ui64 geobaseId) const;

    private:
        template <class... TArgs>
        NThreading::TFuture<TOptionalGeoFeatures> GetImpl(TArgs&&... args) const;
        NThreading::TFuture<TOptionalGeoFeatures> GetScooters(const TScootersSurge& scootersSurge, double latitude, double longitude) const;
        NThreading::TFuture<TOptionalGeoFeatures> GetScooters(const TScootersSurge& scootersSurge, ui64 geobaseId) const;

    private:
        const NRTLine::TNehSearchClient& Client;
        const NDrive::TRtmrSurgeClient& RtmrClient;
        const TAtomicSharedPtr<TScootersSurge> ScootersSurge;
        const TOptions Options;
    };
}
