#include <drive/library/cpp/geofeatures/client.h>

#include <rtline/api/search_client/neh_client.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(GeoFeaturesClient) {
    Y_UNIT_TEST(Simple) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TRtmrSurgeClient rtmrClient;
        NDrive::TGeoFeaturesClient client(searchClient, rtmrClient);
        auto asyncFeatures = client.Get(55.736713, 37.640373);
        auto optionalFeatures = asyncFeatures.ExtractValueSync();
        UNIT_ASSERT(optionalFeatures);
        UNIT_ASSERT(optionalFeatures->SurgeLastDay > -1);
        UNIT_ASSERT(optionalFeatures->SurgeLast2Weeks > -1);
        UNIT_ASSERT(optionalFeatures->SurgeDayWeekAgo > -1);
        UNIT_ASSERT(optionalFeatures->SessionsLastDay > -1);
        UNIT_ASSERT(optionalFeatures->SessionsLast2Weeks > -1);
        UNIT_ASSERT(optionalFeatures->SessionsDayWeekAgo > -1);
        UNIT_ASSERT(optionalFeatures->CarsLastDay > -1);
        UNIT_ASSERT(optionalFeatures->CarsLast2Weeks > -1);
        UNIT_ASSERT(optionalFeatures->CarsDayWeekAgo > -1);
        UNIT_ASSERT(optionalFeatures->OrdersLast2Weeks > -1);
    }

    Y_UNIT_TEST(Geobase) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TRtmrSurgeClient rtmrClient;
        NDrive::TGeoFeaturesClient client(searchClient, rtmrClient);
        auto asyncFeatures = client.Get(117067);
        auto optionalFeatures = asyncFeatures.ExtractValueSync();
        UNIT_ASSERT(optionalFeatures->SurgeLastDayGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SurgeLast2WeeksGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SurgeDayWeekAgoGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SessionsLastDayGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SessionsLast2WeeksGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SessionsDayWeekAgoGeobase > -1);
        UNIT_ASSERT(optionalFeatures->CarsLastDayGeobase > -1);
        UNIT_ASSERT(optionalFeatures->CarsLast2WeeksGeobase > -1);
        UNIT_ASSERT(optionalFeatures->CarsDayWeekAgoGeobase > -1);
        UNIT_ASSERT(optionalFeatures->OrdersLast2WeeksGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SurgeLastWeekGeobase > -1);
        UNIT_ASSERT(optionalFeatures->SessionsLastWeekGeobase > -1);
    }

    Y_UNIT_TEST(Rtmr) {
        NRTLine::TNehSearchClient searchClient("drive_cache", "saas-searchproxy-maps-prestable.yandex.net", 17000);
        NDrive::TRtmrSurgeClient rtmrClient;
        NDrive::TGeoFeaturesClient client(searchClient, rtmrClient);
        auto asyncFeatures = client.Get(55.736713, 37.640373);
        auto optionalFeatures = asyncFeatures.ExtractValueSync();
        UNIT_ASSERT(optionalFeatures);
        UNIT_ASSERT(optionalFeatures->RtSurgePrediction1 > -1);
        UNIT_ASSERT(optionalFeatures->RtSurgePrediction2 > -1);
        UNIT_ASSERT(optionalFeatures->RtSurgePrediction3 > -1);
        UNIT_ASSERT(optionalFeatures->RtSurgePrediction4 > -1);
        UNIT_ASSERT(optionalFeatures->RtSurgePrediction5 > -1);
        UNIT_ASSERT(optionalFeatures->RtSessions60MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtSessions120MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtSessions180MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtSurge60MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtSurge120MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtSurge180MinExtended > -1);
        UNIT_ASSERT(optionalFeatures->RtCars180MinExtended > -1);
    }
}
