#include "features.h"

#include <rtline/library/json/cast.h>

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TGeoFeatures& object) {
    NJson::TJsonValue result;
    result["rt_surge_prediction_1"] = object.RtSurgePrediction1;
    result["rt_surge_prediction_2"] = object.RtSurgePrediction2;
    result["rt_surge_prediction_3"] = object.RtSurgePrediction3;
    result["rt_surge_prediction_4"] = object.RtSurgePrediction4;
    result["rt_surge_prediction_5"] = object.RtSurgePrediction5;
    result["rt_surge_60_min"] = object.RtSurge60Min;
    result["rt_sessions_30_min"] = object.RtSessions30Min;
    result["rt_sessions_60_min"] = object.RtSessions60Min;
    result["rt_sessions_120_min"] = object.RtSessions120Min;

    result["SURGE_LAST_DAY"] = object.SurgeLastDay;
    result["SURGE_LAST_2_WEEKS"] = object.SurgeLast2Weeks;
    result["SURGE_DAY_WEEK_AGO"] = object.SurgeDayWeekAgo;
    result["SESSIONS_LAST_DAY"] = object.SessionsLastDay;
    result["SESSIONS_LAST_2_WEEKS"] = object.SessionsLast2Weeks;
    result["SESSIONS_DAY_WEEK_AGO"] = object.SessionsDayWeekAgo;
    result["CARS_LAST_DAY"] = object.CarsLastDay;
    result["CARS_LAST_2_WEEKS"] = object.CarsLast2Weeks;
    result["CARS_DAY_WEEK_AGO"] = object.CarsDayWeekAgo;
    result["ORDERS_LAST_2_WEEKS"] = object.OrdersLast2Weeks;

    result["SURGE_LAST_DAY_GEOBASE"] = object.SurgeLastDayGeobase;
    result["SURGE_LAST_2_WEEKS_GEOBASE"] = object.SurgeLast2WeeksGeobase;
    result["SURGE_DAY_WEEK_AGO_GEOBASE"] = object.SurgeDayWeekAgoGeobase;
    result["SESSIONS_LAST_DAY_GEOBASE"] = object.SessionsLastDayGeobase;
    result["SESSIONS_LAST_2_WEEKS_GEOBASE"] = object.SessionsLast2WeeksGeobase;
    result["SESSIONS_DAY_WEEK_AGO_GEOBASE"] = object.SessionsDayWeekAgoGeobase;
    result["CARS_LAST_DAY_GEOBASE"] = object.CarsLastDayGeobase;
    result["CARS_LAST_2_WEEKS_GEOBASE"] = object.CarsLast2WeeksGeobase;
    result["CARS_DAY_WEEK_AGO_GEOBASE"] = object.CarsDayWeekAgoGeobase;
    result["ORDERS_LAST_2_WEEKS_GEOBASE"] = object.OrdersLast2WeeksGeobase;
    result["SURGE_LAST_WEEK_GEOBASE"] = object.SurgeLastWeekGeobase;
    result["SESSIONS_LAST_WEEK_GEOBASE"] = object.SessionsLastWeekGeobase;
    result["RT_CARS_0005_MIN_WINDOW"] = object.RtCars0005MinWindow;
    result["RT_CARS_0510_MIN_WINDOW"] = object.RtCars0510MinWindow;
    result["RT_CARS_1015_MIN_WINDOW"] = object.RtCars1015MinWindow;
    result["RT_CARS_1520_MIN_WINDOW"] = object.RtCars1520MinWindow;
    result["RT_CARS_2025_MIN_WINDOW"] = object.RtCars2025MinWindow;
    result["RT_CARS_2530_MIN_WINDOW"] = object.RtCars2530MinWindow;
    result["RT_CARS_3035_MIN_WINDOW"] = object.RtCars3035MinWindow;
    result["RT_CARS_3540_MIN_WINDOW"] = object.RtCars3540MinWindow;
    result["RT_CARS_4045_MIN_WINDOW"] = object.RtCars4045MinWindow;
    result["RT_CARS_4550_MIN_WINDOW"] = object.RtCars4550MinWindow;
    result["RT_CARS_5055_MIN_WINDOW"] = object.RtCars5055MinWindow;
    result["RT_CARS_5560_MIN_WINDOW"] = object.RtCars5560MinWindow;
    return result;
}
