#pragma once

#include <util/generic/maybe.h>

namespace NDrive {
    constexpr double GeoFeaturesDefaultValue = -2;

    struct TGeoFeatures {
        double RtSurgePrediction1 = GeoFeaturesDefaultValue;
        double RtSurgePrediction2 = GeoFeaturesDefaultValue;
        double RtSurgePrediction3 = GeoFeaturesDefaultValue;
        double RtSurgePrediction4 = GeoFeaturesDefaultValue;
        double RtSurgePrediction5 = GeoFeaturesDefaultValue;
        double RtSurge60Min = GeoFeaturesDefaultValue;
        double RtSessions30Min = GeoFeaturesDefaultValue;
        double RtSessions60Min = GeoFeaturesDefaultValue;
        double RtSessions120Min = GeoFeaturesDefaultValue;

        double RtSessions60MinExtended = GeoFeaturesDefaultValue;
        double RtSessions120MinExtended = GeoFeaturesDefaultValue;
        double RtSessions180MinExtended = GeoFeaturesDefaultValue;
        double RtSurge60MinExtended = GeoFeaturesDefaultValue;
        double RtSurge120MinExtended = GeoFeaturesDefaultValue;
        double RtSurge180MinExtended = GeoFeaturesDefaultValue;
        double RtCars180MinExtended = GeoFeaturesDefaultValue;

        double SurgeLastDay = GeoFeaturesDefaultValue;
        double SurgeLast2Weeks = GeoFeaturesDefaultValue;
        double SurgeDayWeekAgo = GeoFeaturesDefaultValue;
        double SessionsLastDay = GeoFeaturesDefaultValue;
        double SessionsLast2Weeks = GeoFeaturesDefaultValue;
        double SessionsDayWeekAgo = GeoFeaturesDefaultValue;
        double CarsLastDay = GeoFeaturesDefaultValue;
        double CarsLast2Weeks = GeoFeaturesDefaultValue;
        double CarsDayWeekAgo = GeoFeaturesDefaultValue;
        double OrdersLast2Weeks = GeoFeaturesDefaultValue;

        double SurgeLastDayGeobase = GeoFeaturesDefaultValue;
        double SurgeLast2WeeksGeobase = GeoFeaturesDefaultValue;
        double SurgeDayWeekAgoGeobase = GeoFeaturesDefaultValue;
        double SessionsLastDayGeobase = GeoFeaturesDefaultValue;
        double SessionsLast2WeeksGeobase = GeoFeaturesDefaultValue;
        double SessionsDayWeekAgoGeobase = GeoFeaturesDefaultValue;
        double CarsLastDayGeobase = GeoFeaturesDefaultValue;
        double CarsLast2WeeksGeobase = GeoFeaturesDefaultValue;
        double CarsDayWeekAgoGeobase = GeoFeaturesDefaultValue;
        double OrdersLast2WeeksGeobase = GeoFeaturesDefaultValue;
        double SurgeLastWeekGeobase = GeoFeaturesDefaultValue;
        double SessionsLastWeekGeobase = GeoFeaturesDefaultValue;

        double RtCars0005MinWindow = GeoFeaturesDefaultValue;
        double RtCars0510MinWindow = GeoFeaturesDefaultValue;
        double RtCars1015MinWindow = GeoFeaturesDefaultValue;
        double RtCars1520MinWindow = GeoFeaturesDefaultValue;
        double RtCars2025MinWindow = GeoFeaturesDefaultValue;
        double RtCars2530MinWindow = GeoFeaturesDefaultValue;
        double RtCars3035MinWindow = GeoFeaturesDefaultValue;
        double RtCars3540MinWindow = GeoFeaturesDefaultValue;
        double RtCars4045MinWindow = GeoFeaturesDefaultValue;
        double RtCars4550MinWindow = GeoFeaturesDefaultValue;
        double RtCars5055MinWindow = GeoFeaturesDefaultValue;
        double RtCars5560MinWindow = GeoFeaturesDefaultValue;
    };
    using TOptionalGeoFeatures = TMaybe<TGeoFeatures>;
}
