#pragma once

#include "geohash.h"

#include <library/cpp/geohash/geohash.h>
#include <util/generic/list.h>

namespace NDrive {

    template<typename T>
    class TPolygonGeohashIndex {
    public:
        TPolygonGeohashIndex(ui8 precision)
            : Precision(precision)
        {
        }

        void Insert(T object, const TPolyLine<TGeoCoord>& polygon) {
            auto it = Objects.insert(Objects.end(), {object, polygon});
            for (auto hash : GetPolygonGeohash(polygon, Precision)) {
                Index.insert({hash, it});
            }
        }

        TVector<T> Find(const TGeoCoord& coord) const {
            auto hash = NGeoHash::EncodeToString(coord.Y, coord.X, Precision);
            auto range = Index.equal_range(hash);
            TVector<T> objects;
            for (auto it = range.first; it != range.second; ++it) {
                if (it->second->second.IsPointInternal(coord)) {
                    objects.push_back(it->second->first);
                }
            }
            return objects;
        }
    
    private:
        using TPair = std::pair<T, TPolyLine<TGeoCoord>>;

        ui8 Precision;
        THashMultiMap<TString, typename TList<TPair>::iterator> Index;
        TList<TPair> Objects;
    };

}
