#include <library/cpp/testing/unittest/registar.h>

#include <drive/library/cpp/geohash/index.h>

Y_UNIT_TEST_SUITE(DriveGeohashIndex) {
    Y_UNIT_TEST(Simple) {
        NDrive::TPolygonGeohashIndex<TString> index(6);
        TPolyLine<TGeoCoord> polyA = TVector<TGeoCoord>{{1, 1}, {1, 2}, {2, 2}, {2, 1}, {1, 1}};
        index.Insert("a", polyA);
        UNIT_ASSERT_VALUES_EQUAL(index.Find({1.5, 1.5}), TVector<TString>{"a"});
        UNIT_ASSERT(index.Find({2.5, 2.5}).empty());
    }
}
