#pragma once

#include <rtline/util/types/messages_collector.h>

#include <contrib/libs/opencv/include/opencv2/imgcodecs/imgcodecs_c.h>
#include <util/memory/blob.h>

namespace NImageTransformation {
    TMaybe<cv::Mat> BlobToOpenCV(const TBlob& blobData, TMessagesCollector& errors);
    TMaybe<TBlob> OpenCVToBlob(const cv::Mat& image, TMessagesCollector& errors, const TString& format = "jpg");

    cv::Mat BlobToOpenCV(const TBlob& blobData, const TString& format = "jpg");
    TBlob OpenCVToBlob(const cv::Mat& image, const TString& format = "jpg");

    class IAbstractTransformation {
    protected:
        virtual bool DoApply(cv::Mat& source) const = 0;

    public:
        virtual ~IAbstractTransformation() = default;
        virtual bool Apply(cv::Mat& source, TMessagesCollector& errors) const;

        virtual bool Transform(const cv::Mat& source, cv::Mat& result, TMessagesCollector& errors) const;
        virtual bool Transform(const TBlob& source, cv::Mat& result, TMessagesCollector& errors, const TString& format = "jpg") const;
        virtual bool Transform(const cv::Mat& source, TBlob& result, TMessagesCollector& errors, const TString& format = "jpg") const;
        virtual bool Transform(const TBlob& source, TBlob& result, TMessagesCollector& errors, const TString& format = "jpg") const;
    };
};
