#include "resize.h"

#include <contrib/libs/opencv/include/opencv2/imgcodecs/imgcodecs_c.h>
#include <contrib/libs/opencv/modules/imgproc/include/opencv2/imgproc.hpp>
#include <contrib/libs/opencv/include/opencv2/opencv.hpp>

namespace NImageTransformation {

    bool TResize::DoApply(cv::Mat& source) const {
        size_t sizeX = source.cols;
        size_t sizeY = source.rows;

        if (sizeX == 0 || sizeY == 0) {
            return true;
        }

        size_t newX, newY;
        if (sizeX >= sizeY) {
            newX = MaxSide;
            newY = MaxSide * sizeY / sizeX;
        } else {
            newY = MaxSide;
            newX = MaxSide * sizeX / sizeY;
        }

        cv::Mat result;
        resize(source, result, cv::Size(newX, newY), 0, 0, cv::InterpolationFlags::INTER_LINEAR);

        source = result;
        return true;
    }

    bool TCompress::DoApply(cv::Mat& source) const {
        TVector<uchar> buf;
        cv::imencode(".jpg", source, buf, {cv::IMWRITE_JPEG_QUALITY, Compression});
        source = cv::imdecode(buf, cv::IMREAD_COLOR);
        return true;
    }
};
