#pragma once

#include "abstract.h"

#include <rtline/util/types/accessor.h>

namespace NImageTransformation {
    class TResize : public IAbstractTransformation {
        R_READONLY(ui32, MaxSide, 300);

    protected:
        virtual bool DoApply(cv::Mat& source) const override;

    public:
        TResize(const ui32 maxSide)
            : MaxSide(maxSide)
        {
        }
    };

    class TCompress : public IAbstractTransformation {
        R_READONLY(ui16, Compression, 100);

    protected:
        virtual bool DoApply(cv::Mat& source) const override;

    public:
        TCompress(const ui16 compress)
            : Compression(compress)
        {
        }
    };
};
