#pragma once

#include "resize.h"
#include "watermark.h"


namespace NImageTransformation {

    class TTransformationConfig {
    public:
        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& json);
        NDrive::TScheme GetScheme() const;
        bool NeedCompression() const;

    private:
        R_FIELD(TWatermarkConfig, WatermarkConfig);
        R_FIELD(bool, NeedWatermark, false);
        R_FIELD(ui16, Compression, 100);
        R_FIELD(ui32, MaxSide, 0);
    };

    class TTransformation {
    public:
        TTransformation(const TTransformationConfig& config, const TString& watermarkText = "")
            : Config(config)
            , WatermarkText(watermarkText)
        {
        }

        bool Transform(const TString& source, TString& result, TMessagesCollector& errors, const TString& format = "jpg") const;

    private:
        R_FIELD(TTransformationConfig, Config);
        R_FIELD(TString, WatermarkText);
    };

}
