#include "video_first_frame.h"

#include <util/system/shellcommand.h>
#include <util/generic/vector.h>
#include <util/stream/file.h>
#include <util/stream/fwd.h>
#include <util/generic/guid.h>

namespace NImageTransformation {
    bool TFirstFrameExtractor::Extract(const TBlob& source, TBlob& result, const TString& format) {
        TString sourceFile = "/dev/shm/" + CreateGuidAsString() + "." + format;
        {
            TMemoryInput inp(source.Data(), source.Size());
            TFileOutput fileOutput(sourceFile);
            fileOutput << inp.ReadAll();
        }
        TString destinationFile = "/dev/shm/" + CreateGuidAsString() + ".jpg";
        TString command = FFMpegPath + " -i " + sourceFile + " -vframes 1 " + destinationFile;
        {
            TShellCommand sc(command);
            sc.Run().Wait();
            TFsPath(sourceFile).ForceDelete();
            if (sc.GetStatus() != TShellCommand::SHELL_FINISHED) {
                TFsPath(destinationFile).ForceDelete();
                WARNING_LOG << "stdout: " << sc.GetOutput() << Endl;
                WARNING_LOG << "stderr: " << sc.GetError() << Endl;
                return false;
            }
        }
        result = TBlob::FromFile(destinationFile);
        TFsPath(destinationFile).ForceDelete();
        return true;
    }
};
