#pragma once

#include "abstract.h"

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/types/accessor.h>

#include <library/cpp/yconf/conf.h>

#include <contrib/libs/opencv/include/opencv2/opencv.hpp>


namespace NImageTransformation {

    class TWatermarkConfig {
    public:
        enum class EFont {
            Simplex = CV_FONT_HERSHEY_SIMPLEX               /* "simplex" */,
            Plain = CV_FONT_HERSHEY_PLAIN                   /* "plain" */,
            Duplex = CV_FONT_HERSHEY_DUPLEX                 /* "duplex" */,
            Complex = CV_FONT_HERSHEY_COMPLEX               /* "complex" */,
            Triplex = CV_FONT_HERSHEY_TRIPLEX               /* "triplex" */,
            ComplexSmall = CV_FONT_HERSHEY_COMPLEX_SMALL    /* "complex_small" */,
            ScriptSimplex = CV_FONT_HERSHEY_SCRIPT_SIMPLEX  /* "script_simplex" */,
            ScriptComplex = CV_FONT_HERSHEY_SCRIPT_COMPLEX  /* "script_complex" */,
        };

        struct TSpaceParams {
            ui32 Min = 0;
            ui32 Max = 0;
            double Coefficient = 0.0;

        public:
            ui32 GetSpace(const ui32 size) const;
        };

    public:
        TWatermarkConfig();
        NJson::TJsonValue SerializeToJson() const;
        bool DeserializeFromJson(const NJson::TJsonValue& json);
        NDrive::TScheme GetScheme() const;

    private:
        R_READONLY(EFont, Font, EFont::Duplex);
        R_READONLY(ui32, FontScale, 2);
        R_READONLY(ui32, Thickness, 2);
        R_READONLY(TSpaceParams, VerticalSpace);
        R_READONLY(TSpaceParams, HorizontalSpace);
        R_READONLY(double, Rotation, -45.0);
        R_READONLY(double, Alpha, 0.2);
    };

    class TWatermark : public IAbstractTransformation {
        R_READONLY(TWatermarkConfig, Config);
        R_READONLY(TString, Text);

    protected:
        virtual bool DoApply(cv::Mat& source) const override;

    public:
        TWatermark(const TWatermarkConfig& config, const TString& text);

    };
};
