#pragma once

#include "config.h"
#include "entities.h"


namespace NDrive {

    class TJeepClient {
    public:
        TJeepClient(const TJeepApiConfig& config);
        const TJeepApiConfig& GetConfig() const;
        NThreading::TFuture<void> SendLead(const TJeepRequestData& context) const;

    private:
        NThreading::TFuture<TString> GetAuthToken() const;

    private:
        TJeepApiConfig Config;
        TAtomicSharedPtr<NNeh::THttpClient> Client;
    };

}
