#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/folder/path.h>
#include <util/stream/file.h>

namespace NDrive {

    bool TJeepApiConfig::Init(const TYandexConfig::Section* section) {
        Uri = section->GetDirectives().Value("Uri", Uri);
        UriPath = section->GetDirectives().Value("UriPath", UriPath);
        Login = section->GetDirectives().Value("Login", Login);
        Token = section->GetDirectives().Value("Token", Token);
        TokenPath = section->GetDirectives().Value("TokenPath", TokenPath);
        if (!Token && !TokenPath) {
            ERROR_LOG << "neither token nor token path are defined" << Endl;
            return false;
        }
        if (!Token) {
            if (!TFsPath(TokenPath).Exists()) {
                ERROR_LOG << "Incorrect path for tanker's apikey in 'TokenPath'" << Endl;
                return false;
            }
            TFileInput fi(TokenPath);
            Token = fi.ReadAll();
        }
        {
            const TYandexConfig::TSectionsMap children = section->GetAllChildren();
            auto it = children.find("RequestConfig");
            if (it != children.end()) {
                RequestConfig.InitFromSection(it->second);
            }
        }
        RequestTimeout  = section->GetDirectives().Value("RequestTimeout", RequestTimeout);
        return true;
    }

    void TJeepApiConfig::ToString(IOutputStream& os) const {
        os << "Uri: " << Uri << Endl;
        os << "UriPath: " << UriPath << Endl;
        os << "Login: " << Login << Endl;
        if (TokenPath) {
            os << "TokenPath: " << TokenPath << Endl;
        }
        os << "<RequestConfig>" << Endl;
        RequestConfig.ToString(os);
        os << "</RequestConfig>" << Endl;
        os << "RequestTimeout : " << RequestTimeout << Endl;
    }

    TAtomicSharedPtr<TJeepApiConfig> TJeepApiConfig::ParseFromString(const TString& configStr) {
        TAnyYandexConfig config;
        if (!config.ParseMemory(configStr.data())) {
            ERROR_LOG << "Fail to parse config:" + configStr << Endl;
            return nullptr;
        }
        auto result = MakeAtomicShared<TJeepApiConfig>();
        if (!result->Init(config.GetRootSection())) {
            return nullptr;
        }
        return result;
    }

}
