#pragma once

#include <rtline/util/network/neh.h>
#include <rtline/util/types/accessor.h>

#include <kernel/daemon/config/daemon_config.h>

namespace NDrive {

    class TJeepApiConfig {
    public:
        bool Init(const TYandexConfig::Section* section);
        void ToString(IOutputStream& os) const;
        static TAtomicSharedPtr<TJeepApiConfig> ParseFromString(const TString& configStr);

    private:
        R_READONLY(TString, Uri, "https://fca.dmbasis.agency/");
        R_READONLY(TString, UriPath, "russianleads/prod/v1/RussianLeadsService.wsdl");
        R_READONLY(TString, Login, "yandexDriveJeep");
        R_READONLY(TString, Token);
        R_READONLY(TString, TokenPath);
        R_READONLY(NSimpleMeta::TConfig, RequestConfig);
        R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
    };

}
