#pragma once

#include <drive/library/cpp/raw_text/datetime.h>

#include <rtline/util/types/accessor.h>


namespace NDrive {

    class TJeepRequestData {
    public:
        class TPersonalData {
        public:
            enum class ECity {
                Msk,
                Spb,
                Kzn,
            };

        public:
            void ToString(IOutputStream& os) const;

        private:
            R_FIELD(TString, UserId);
            R_FIELD(TString, UserName);
            R_FIELD(TString, Surname);
            R_FIELD(TString, Email);
            R_FIELD(TString, Phone);
            R_FIELD(ECity, City, ECity::Msk);
        };

        class TPrivacyData {
        public:
            using TAgreements = ui32;
            enum EAgreements : ui32 {
                ProcessingPermission = 0,  // always
                EmailPermission = 1 << 0,
                SMSPermission = 1 << 1,
                PhonePermission = 1 << 2,
                PostPermission = 1 << 3,
                ThirdPartyPermission = 1 << 4,
                GeoLocationPermission = 1 << 5,
                ProfilationPermission = 1 << 6,
                ExtraUEPermission = 1 << 7,
                CrossBorderPermission = 1 << 8,
            };

        public:
            void ToString(IOutputStream& os) const;

        private:
            R_FIELD(ui32, DisclaimerId, 1);
            R_FIELD(TAgreements, Agreements, SMSPermission | EmailPermission | PhonePermission | ThirdPartyPermission | CrossBorderPermission);
        };

        class TLeadData {
        public:
            enum class ELeadStatusId {
                Dormant = 1     /* "1" */, // Не ожидает какой-либо обратной связи
                WaitforDC = 2   /* "2" */, // Ожидает звонка от оператора Д
            };

        public:
            void ToString(IOutputStream& os) const;

        private:
            R_FIELD(ui32, LeadTypeId, 7); // 7 - Информационный запрос
            R_FIELD(TString, InterestBrandCode, "057");
            R_FIELD(TString, InterestModelCode, "684");
            R_FIELD(ui32, DealerId, 740053);
            R_FIELD(ELeadStatusId, LeadStatusId, ELeadStatusId::Dormant);
        };

        class TRequestData {
        public:
            void ToString(IOutputStream& os) const;

        private:
            R_FIELD(TString, ExternalRequestId);
            R_FIELD(TString, OriginId, "383");
            R_FIELD(TInstant, RequestDate, TInstant::Zero());
        };

        class TRequestExtraField {
        public:
            enum class EExtraFieldName {
                Default,
                RentStartDate,
                RentEndDate,
            };

        public:
            TRequestExtraField(EExtraFieldName type, const TString& data);
            void ToString(IOutputStream& os) const;

        private:
            R_FIELD(ui64, Id, 1);
            R_FIELD(EExtraFieldName, ExtraFieldName, EExtraFieldName::Default);
            R_FIELD(TString, Data);
        };

    public:
        void ToString(IOutputStream& os) const;

    private:
        R_FIELD(TPersonalData, PersonalData);
        R_FIELD(TPrivacyData, PrivacyData);
        R_FIELD(TLeadData, LeadData);
        R_FIELD(TRequestData, RequestData);
        R_FIELD(TVector<TRequestExtraField>, RequestExtraFields);
    };

}
