#include <drive/library/cpp/jeep/client.h>
#include <drive/library/cpp/threading/future.h>

#include <library/cpp/testing/unittest/tests_data.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/json/json_reader.h>

#include <util/generic/vector.h>
#include <util/string/builder.h>
#include <util/system/env.h>


namespace {
    const TString testRequestBody = "<PersonalData><ExternalId>123</ExternalId><Name>Тест</Name><Surname>Тестов</Surname><Phone>+71234567890</Phone><Email>test@yandex.ru</Email><Country>RUS</Country><RegionId>77</RegionId><City>Г. Москва</City></PersonalData><PrivacyData><DisclaimerId>1</DisclaimerId><ProcessingPermission>true</ProcessingPermission><EmailPermission>true</EmailPermission><SMSPermission>true</SMSPermission><PhonePermission>true</PhonePermission><PostPermission>false</PostPermission><ThirdPartyPermission>true</ThirdPartyPermission><GeoLocationPermission>false</GeoLocationPermission><ProfilationPermission>false</ProfilationPermission><ExtraUEPermission>false</ExtraUEPermission><CrossBorderPermission>true</CrossBorderPermission></PrivacyData><LeadData><LeadTypeId>7</LeadTypeId><InterestBrandCode>057</InterestBrandCode><InterestModelCode>684</InterestModelCode><DealerId>740053</DealerId><LeadStatusId>1</LeadStatusId></LeadData><RequestData><ExternalRequestId>123</ExternalRequestId><OriginId>383</OriginId><RequestDate>2021-06-30T12:00:00+03:00</RequestDate></RequestData><RequestExtraFields><RequestExtraField><Id>1</Id><ExtraFieldName>RentStartDate</ExtraFieldName><ExtraField>2021-06-30T12:00:00+03:00</ExtraField></RequestExtraField><RequestExtraField><Id>1</Id><ExtraFieldName>RentEndDate</ExtraFieldName><ExtraField>2021-06-30T12:00:00+03:00</ExtraField></RequestExtraField></RequestExtraFields>";
    const TInstant testRequestInstant = TInstant::Seconds(1625043600);
}

Y_UNIT_TEST_SUITE(DriveJeepSuite) {
    NDrive::TJeepApiConfig GetFinesConfig() {
        auto config = TStringBuilder()
            << "UriPath: " << "russianleads/test/v1/RussianLeadsService.wsdl" << Endl;
        if (auto token = GetEnv("JeepApiToken")) {
            config << "Token: " << token << Endl;
        }
        DEBUG_LOG << config << Endl;
        auto result = NDrive::TJeepApiConfig::ParseFromString(config);
        UNIT_ASSERT(!!result);
        return *result;
    }

    Y_UNIT_TEST(SimpleRequest) {
        DoInitGlobalLog("console", FromString<ui32>(GetEnv("LogLevel", "6")), false, false);
        auto config = GetFinesConfig();
        const NDrive::TJeepClient client(config);
        NDrive::TJeepRequestData data;
        data.MutablePersonalData().SetUserId("123");
        data.MutablePersonalData().SetUserName("Тест");
        data.MutablePersonalData().SetSurname("Тестов");
        data.MutablePersonalData().SetEmail("test@yandex.ru");
        data.MutablePersonalData().SetPhone("+71234567890");
        data.MutableRequestData().SetExternalRequestId("123");
        data.MutableRequestData().SetRequestDate(testRequestInstant);
        data.MutableRequestExtraFields().emplace_back(NDrive::TJeepRequestData::TRequestExtraField::EExtraFieldName::RentStartDate, testRequestInstant.ToIsoStringLocalUpToSeconds());
        data.MutableRequestExtraFields().emplace_back(NDrive::TJeepRequestData::TRequestExtraField::EExtraFieldName::RentEndDate, testRequestInstant.ToIsoStringLocalUpToSeconds());
        {
            TStringStream s;
            data.ToString(s);
            UNIT_ASSERT_STRINGS_EQUAL(s.Str(), testRequestBody);
        }
        auto future = client.SendLead(data);
        UNIT_ASSERT(future.Wait(config.GetRequestTimeout()));
        UNIT_ASSERT_C(future.HasValue(), NThreading::GetExceptionMessage(future));
    }
}
