#include "aws.h"

#include <rtline/library/json/parse.h>

#include <contrib/libs/jwt-cpp/include/jwt-cpp/jwt.h>

namespace {
    const std::string EmailPayloadClaim = "email";
    const std::string PhonePayloadClaim = "phone_number";
    const std::string EmailVerifiedPayloadClaim = "email_verified";
    const std::string PhoneVerifiedPayloadClaim = "phone_number_verified";
    const std::string CognitoUsernamePayloadClaim = "cognito:username";
}

NDrive::TAmazonCognitoIdToken NDrive::ParseCognitoIdToken(const jwt::decoded_jwt& token) {
    NDrive::TAmazonCognitoIdToken result;
    result.Algorithm = token.get_algorithm();
    result.KeyId = token.get_key_id();
    result.Issuer = token.get_issuer();
    result.IssuedAt = TInstant::Zero() + TDuration(token.get_issued_at().time_since_epoch());
    result.Deadline = TInstant::Zero() + TDuration(token.get_expires_at().time_since_epoch());
    result.UserId = token.get_subject();
    if (token.has_payload_claim(CognitoUsernamePayloadClaim)) {
        result.Username = token.get_payload_claim(CognitoUsernamePayloadClaim).as_string();
    }
    if (token.has_payload_claim(EmailPayloadClaim)) {
        result.Email = token.get_payload_claim(EmailPayloadClaim).as_string();
    }
    if (token.has_payload_claim(PhonePayloadClaim)) {
        result.Phone = token.get_payload_claim(PhonePayloadClaim).as_string();
    }
    if (token.has_payload_claim(EmailVerifiedPayloadClaim)) {
        result.EmailVerified = token.get_payload_claim(EmailVerifiedPayloadClaim).as_bool();
    }
    if (token.has_payload_claim(PhoneVerifiedPayloadClaim)) {
        result.PhoneVerified = token.get_payload_claim(PhoneVerifiedPayloadClaim).as_bool();
    }
    return result;
}

template <>
NJson::TJsonValue NJson::ToJson(const NDrive::TAmazonCognitoIdToken& object) {
    NJson::TJsonValue result;
    NJson::InsertNonNull(result, "algorithm", object.Algorithm);
    NJson::InsertNonNull(result, "key_id", object.KeyId);
    NJson::InsertNonNull(result, "auth_time", object.AuthTime.Seconds());
    NJson::InsertNonNull(result, "deadline", object.Deadline.Seconds());
    NJson::InsertNonNull(result, "issued_at", object.IssuedAt.Seconds());
    NJson::InsertNonNull(result, "issuer", object.Issuer);
    NJson::InsertNonNull(result, "email", object.Email);
    NJson::InsertNonNull(result, "phone", object.Phone);
    NJson::InsertNonNull(result, "user_id", object.UserId);
    NJson::InsertNonNull(result, "username", object.Username);
    NJson::InsertNonNull(result, "email_verified", object.EmailVerified);
    NJson::InsertNonNull(result, "phone_verified", object.PhoneVerified);
    return result;
}
