#pragma once

#include <util/datetime/base.h>
#include <util/generic/string.h>

namespace jwt {

class decoded_jwt;

} // namespace jwt;

namespace NDrive {
    struct TAmazonCognitoIdToken {
        TString Algorithm;
        TString KeyId;

        TInstant AuthTime;
        TInstant Deadline;
        TInstant IssuedAt;
        TString Issuer;
        TString Email;
        TString Phone;
        TString UserId;
        TString Username;

        bool EmailVerified = false;
        bool PhoneVerified = false;
    };

    TAmazonCognitoIdToken ParseCognitoIdToken(const jwt::decoded_jwt& token);
}
