#include "aws.h"
#include "key.h"

#include <library/cpp/testing/unittest/registar.h>

namespace {
    const TString SampleToken = "eyJraWQiOiJJUDFZVHR2aFNnQkxFRmNSVVplaWljNFhtRnJYVTdEc0g0UVlocWw2SHhVPSIsImFsZyI6IlJTMjU2In0.eyJzdWIiOiI0MDFmNjQ5MC00NjM0LTQ1YzctODZhYi0wYzMwOTg1ZjI2NmUiLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwiaXNzIjoiaHR0cHM6XC9cL2NvZ25pdG8taWRwLmV1LWNlbnRyYWwtMS5hbWF6b25hd3MuY29tXC9ldS1jZW50cmFsLTFfOFBSOVF5S0Z1IiwicGhvbmVfbnVtYmVyX3ZlcmlmaWVkIjpmYWxzZSwiY29nbml0bzp1c2VybmFtZSI6IjQwMWY2NDkwLTQ2MzQtNDVjNy04NmFiLTBjMzA5ODVmMjY2ZSIsIm9yaWdpbl9qdGkiOiJjZWYyOWE4ZC02Njk1LTRkZTItYTMwOS0wMjQ5MjI3YWEzN2UiLCJhdWQiOiIxbTgxZDhyZzdrdHIwY2IxMmpudmh0bG05biIsImV2ZW50X2lkIjoiNjAyOGJhNjktYTRlYy00ZDdjLWIxYzQtZjZmODI1OGM1NjNiIiwidG9rZW5fdXNlIjoiaWQiLCJhdXRoX3RpbWUiOjE2NDk2ODAxMDksInBob25lX251bWJlciI6Iis3OTUyODA3MzAzNCIsImV4cCI6MTY0OTY4MzcwOSwiaWF0IjoxNjQ5NjgwMTA5LCJqdGkiOiJiNGNlZWM5Zi1iMGNiLTRmYTUtYjY5ZS1jZDE3MGJmMjM5NjgiLCJlbWFpbCI6Imtvemh1aGFyLmtpcmlsbEBnbWFpbC5jb20ifQ.AsQ1y_pQQmw77pAa0YOp2UpI0aWB0Lv5X8BoqCE_1ZU25IwSOzp2NtzAVXo4Kt9zzXF-PRo_emuJhqpoNHWFKzOVYG5ov1xejDgvSLFdrQQg4V2hX-KmgYXbMBu-ctj2ZQNJcCPHA4c_gHiIo4ePZ1N5Z7wy8W_HBNV_ZFomlfIvcgbRkdgyF7tDIBlNMN2LQhCG1JSD9kDbG1MKVddCDWUj9JQdhvTXaMvBpCPcFUI6_ndtFefeYSZZzZXZgwtECD78bkT0RZL0wR2g8j08k7KK5OztenZVVfvs4FJnufBYZYZcNT2XkqpEe1_RUbbzRZ1TJLycgqacrWjIxr1pzw";
    const TString SampleKeyId = "IP1YTtvhSgBLEFcRUZeiic4XmFrXU7DsH4QYhql6HxU=";
    const TString SampleKeyPEM = R"(
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsP+oyCoqHaO5NWtczV8L
4ipllYm9tFu9PWMxuk8BEQaJXZxdUKdceNKrF5wrUL/C81YeS0sW5wOIZ66540nI
lwtZvI5OaWqP26hzYTAzZL0Rp7R4SRFIciCof+nCmiENjml9ePUXgTrBU+TsjUhW
bkknQ3KBodpf+M/PuYQmdGbjxcRuNrniWl3C9u/JUc0tawby/fisyWqJdytk7Nu2
5/SANUhoYvO678f9dDD50vr33X9sY8mBjaE8ijiB2iv3tOn4qekb0JnlR9ht8C5j
m2PbswTf2JyTU7YFuxEBo77D06jZtgAMbuzTVI+ADCIiNFN/6GyPFmMuh+YcISLt
kQIDAQAB
)";
}

Y_UNIT_TEST_SUITE(AwsJwtTokens) {
    Y_UNIT_TEST(Parse) {
        auto token = jwt::decode(SampleToken);
        auto parsed = NDrive::ParseCognitoIdToken(token);
        UNIT_ASSERT_VALUES_EQUAL(parsed.Algorithm, "RS256");
        UNIT_ASSERT_VALUES_EQUAL(parsed.KeyId, "IP1YTtvhSgBLEFcRUZeiic4XmFrXU7DsH4QYhql6HxU=");
        UNIT_ASSERT_VALUES_EQUAL(parsed.UserId, "401f6490-4634-45c7-86ab-0c30985f266e");
        UNIT_ASSERT_VALUES_EQUAL(parsed.Username, "401f6490-4634-45c7-86ab-0c30985f266e");
        UNIT_ASSERT_VALUES_EQUAL(parsed.Email, "kozhuhar.kirill@gmail.com");
        UNIT_ASSERT_VALUES_EQUAL(parsed.EmailVerified, true);
        UNIT_ASSERT_VALUES_EQUAL(parsed.Phone, "+79528073034");
        UNIT_ASSERT_VALUES_EQUAL(parsed.PhoneVerified, false);
        UNIT_ASSERT_VALUES_EQUAL(parsed.Deadline, TInstant::Seconds(1649683709));
        UNIT_ASSERT_VALUES_EQUAL(parsed.IssuedAt, TInstant::Seconds(1649680109));
    }

    Y_UNIT_TEST(Validate) {
        auto token = jwt::decode(SampleToken);
        NDrive::TJwks keys;
        keys.emplace_back(NDrive::TJwkDescription{
            TString{"RS256"},
            SampleKeyId,
            SampleKeyPEM
        });

        NDrive::ValidateToken(token, keys);
        NDrive::ValidateToken(token, keys.back());
    }
}
