#pragma once

#include <contrib/libs/jwt-cpp/include/jwt-cpp/jwt.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

namespace NDrive {
    struct TJwkDescription {
        TString Algorithm;
        TString KeyId;
        TString PEM;
    };
    using TJwkDescriptions = TVector<TJwkDescription>;

    struct TJwk {
        std::variant<
            jwt::algorithm::none,
            jwt::algorithm::rs256
        > Algorithm;
        TString KeyId;

        TJwk() = default;
        TJwk(const TJwkDescription& description);
    };
    using TJwks = TVector<TJwk>;

    void ValidateToken(const jwt::decoded_jwt& token, const TJwk& key);
    void ValidateToken(const jwt::decoded_jwt& token, const TJwks& keys);
}
