#pragma once

#include <drive/library/cpp/lbs/network/cell.h>

#include <rtline/util/network/neh.h>

#include <library/cpp/json/json_value.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NDrive {
    class TLBSClient {
    public:
        struct TCell: public TGSMCell {
            TDuration Age;

            TCell() = default;
            TCell(const TGSMCell& cell, TDuration age)
                : TGSMCell(cell)
                , Age(age)
            {
            }

            NJson::TJsonValue ToJson() const;
        };
        struct TQuery {
            TVector<TCell> Cells;
            TMaybe<TString> IpV4;

            NJson::TJsonValue ToJson(TStringBuf apikey = {}) const;
        };
        struct TPosition {
            double Latitude = 0;
            double Longitude = 0;
            double Altitude = 0;
            double Precision = 0;
            double AltitudePrecision = 0;
            TString Type;

            bool TryFromJson(const NJson::TJsonValue& value);
        };
        struct TResponse {
            TMaybe<TPosition> Position;
            TMaybe<TString> Error;

            bool TryFromJson(const NJson::TJsonValue& value);
        };

    public:
        TLBSClient(const TString& token, const TString& url = "http://api.lbs.yandex.net/geolocation", TAsyncDelivery::TPtr asyncDelivery = nullptr);
        ~TLBSClient();

        NThreading::TFuture<TResponse> Locate(const TQuery& query) const;

    private:
        NNeh::THttpRequest CreateRequest(const TQuery& query) const;

    private:
        const TString Base;
        const TString Token;
        const TDuration Timeout;

        TAsyncDelivery::TPtr AsyncDelivery;
        TAsyncDelivery::TPtr ExternalAsyncDelivery;
        THolder<NNeh::THttpClient> Requester;
    };
}
