#include "cell.h"

#include <util/string/split.h>

namespace {
    bool TryFromHex(const TString& s, ui32& value) {
        char* p = nullptr;
        auto v = std::strtoul(s.c_str(), &p, 16);
        if (p) {
            value = v;
            return true;
        } else {
            return false;
        }
    }
}

TVector<TGSMCell> ParseCells(TStringBuf s) {
    TVector<TGSMCell> cells;
    for (auto&& line : StringSplitter(s).Split('\n').SkipEmpty()) {
        TStringBuf parameters = line.Token().After('"').Before('"');
        auto parse = [&parameters] (auto& value) {
            TStringBuf token;
            return parameters.NextTok(',', token) && TryFromString(token, value);
        };
        TGSMCell cell;
        TString cellId;
        TString lac;
        ui64 bsic;
        auto parsed =
            parse(cell.MCC) &&
            parse(cell.MNC) &&
            parse(lac) &&
            parse(cellId) &&
            parse(bsic) &&
            parse(cell.SignalLevel);
        if (!parsed) {
            continue;
        }
        if (!TryFromHex(cellId, cell.CellId)) {
            continue;
        }
        if (!TryFromHex(lac, cell.LAC)) {
            continue;
        }
        cells.push_back(cell);
    }
    return cells;
}
